/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipf.oipfg;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.SwingUtilities;
import oracle.ewt.button.ButtonBar;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEditListener;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.meter.BoundedRangeModelImpl;
import oracle.ewt.meter.ProgressBar;
import oracle.ewt.meter.StringRangeModel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.TableScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifw.OiifwWizDialog;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIProgressUIListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqResultsSummary;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipf.oipfg.OipfgPrereqDisplayData;
import oracle.sysman.oip.oipf.oipfg.OipfgPrereqGrid;
import oracle.sysman.oip.oipf.oipfg.OipfgPrereqSpreadTable;

public class OipfgPrereqProgressPanel
extends LWContainer
implements ActionListener,
GridRowSelectListener,
KeyListener {
    private OipfgPrereqSpreadTable m_table;
    private ArrayTwoDDataSource m_dataModel;
    private ArrayOneDDataSource m_headerSource = null;
    private Vector m_vChecks;
    private static int INSET = 5;
    private int m_nFailedStartIndex = -1;
    private DetailsArea m_oDetailsArea;
    private LWContainer m_cardPanel;
    private ProgressBar m_progressbar;
    private BoundedRangeModelImpl m_oRangemodel;
    private LWLabel m_summaryText;
    private LWButton m_oStopButton;
    private LWButton m_oRetryButton;
    private static final String RETRY_COMMAND = "retry";
    private static final String STOP_COMMAND = "stop";
    private OipcpIProgressUIListener m_oProgressUIListener;
    private int m_iFailures = 0;
    private int m_iWarnings = 0;
    private int m_iRequireVerification = 0;
    private OipcpIPrereqChecker m_prereqchecker = null;
    private OiifwWizDialog m_oWizDialog;
    private static boolean continueOnAllChecksPass = false;
    private int m_guimode = 0;

    public OipfgPrereqProgressPanel(Vector vChecks) {
        this.m_vChecks = vChecks;
        continueOnAllChecksPass = false;
        this.createPanelComponents();
    }

    public OipfgPrereqProgressPanel(Vector vChecks, OipcpIPrereqChecker checkerObj, int modeGUI) {
        this.setGUImode(modeGUI);
        this.m_vChecks = vChecks;
        this.m_prereqchecker = checkerObj;
        this.createPanelComponents();
    }

    private void createDataSources() {
        Object[] headerItems = new String[]{OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0110"), OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0111"), "", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0112")};
        this.m_headerSource = new ArrayOneDDataSource(headerItems);
        this.m_dataModel = new ArrayTwoDDataSource(4, this.m_vChecks.size());
        int nCount = this.m_vChecks.size();
        for (int i = 0; i < nCount; ++i) {
            OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)this.m_vChecks.elementAt(i);
            OipfgPrereqDisplayData oData = new OipfgPrereqDisplayData(oCheck);
            this.m_dataModel.setData(0, i, (Object)oData);
            this.m_dataModel.setData(3, i, (Object)oData);
            this.m_dataModel.setData(1, i, (Object)oData);
            this.m_dataModel.setData(2, i, (Object)Boolean.FALSE);
        }
    }

    private void createPanelComponents() {
        String boolVal;
        if (System.getProperty("oracle.installer.continueOnAllChecksPass") != null && (boolVal = System.getProperty("oracle.installer.continueOnAllChecksPass")).equalsIgnoreCase("true")) {
            continueOnAllChecksPass = true;
        }
        if (this.m_oWizDialog != null) {
            this.m_oWizDialog.setNavButtonState(2, false);
            this.m_oWizDialog.setNavButtonState(4, false);
        }
        this.setLayout(new BorderLayout(6, 6));
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(INSET, INSET, INSET, INSET));
        String sHeader = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0114");
        MultiLineLabel descLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), sHeader);
        descLabel.setPreferredAspectRatio(0.0f);
        LWContainer tablePanel = this.createChecksPanel();
        tablePanel.setSize(200, 200);
        LWContainer detailsPanel = this.createDetailsPanel();
        if (this.m_prereqchecker != null) {
            if (!this.m_prereqchecker.getExecuteRemotePrereqs()) {
                this.add((Component)descLabel, "North");
                this.add((Component)tablePanel, "Center");
                this.add((Component)detailsPanel, "South");
            } else {
                this.add((Component)tablePanel, "Center");
                this.add((Component)detailsPanel, "South");
            }
        } else {
            this.add((Component)descLabel, "North");
            this.add((Component)tablePanel, "Center");
            this.add((Component)detailsPanel, "South");
        }
    }

    private LWContainer createChecksPanel() {
        LWContainer panel = new LWContainer();
        this.createDataSources();
        this.m_table = new OipfgPrereqSpreadTable((TwoDDataSource)this.m_dataModel, (OneDDataSource)this.m_headerSource, null);
        this.m_table.setScrollByRow(true);
        this.m_table.setScrollByColumn(false);
        Grid grid = this.m_table.getGrid();
        grid.addEditListener((GridEditListener)new OipfgCheckSelectionHandler());
        grid.addRowSelectListener((GridRowSelectListener)this);
        SingleRowSelection rowSelObj = new SingleRowSelection();
        rowSelObj.setParent(grid);
        grid.setGridSelection((GridSelection)rowSelObj);
        this.m_table.setColumnWidth(2, 20);
        this.m_table.setColumnWidth(0, 385);
        this.m_table.setColumnWidth(3, 115);
        this.m_table.setColumnWidth(1, 75);
        Header header = this.m_table.getColumnHeader();
        header.setHeaderSelection(NullItemSelection.getHeaderSelection());
        header.setCanMoveItems(false);
        header.setCanResizeItems(true);
        panel.setLayout((LayoutManager)new BorderLayout());
        LWContainer tmpPanel = new LWContainer((LayoutManager)new OiifbStackLayout(1));
        panel.add((Component)tmpPanel, (Object)"Center");
        TableScrollBox tableScroll = new TableScrollBox((Component)((Object)this.m_table), 0, 0);
        if (this.getGUImode() == 1) {
            tmpPanel.add("Top Left HEIGHT=130 WIDTH=600 ".toUpperCase(Locale.ENGLISH), (Component)tableScroll);
        } else {
            tmpPanel.add("Top Left HEIGHT=100 WIDTH=570 ".toUpperCase(Locale.ENGLISH), (Component)tableScroll);
        }
        tmpPanel.add("Top Right".toUpperCase(Locale.ENGLISH), (Component)this.createButtonBar());
        tmpPanel.add("Top Left Wide".toUpperCase(Locale.ENGLISH), (Component)this.createProgressPanel());
        return panel;
    }

    private ButtonBar createButtonBar() {
        this.m_oRetryButton = new LWButton(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0124"));
        this.m_oRetryButton.setLeftmost(true);
        this.m_oRetryButton.setActionCommand(RETRY_COMMAND);
        this.m_oRetryButton.addKeyListener((KeyListener)this);
        this.m_oRetryButton.setFocusable(true);
        this.m_oRetryButton.setMnemonicChar('R');
        this.m_oStopButton = new LWButton(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0125"));
        this.m_oStopButton.setRightmost(true);
        this.m_oStopButton.setActionCommand(STOP_COMMAND);
        this.m_oRetryButton.addActionListener((ActionListener)this);
        this.m_oStopButton.addActionListener((ActionListener)this);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)this.m_oRetryButton);
        buttonBar.add((Component)this.m_oStopButton);
        return buttonBar;
    }

    private LWContainer createDetailsPanel() {
        LWContainer panel = new LWContainer((LayoutManager)new BorderLayout());
        this.m_oDetailsArea = new DetailsArea("");
        if (this.getGUImode() == 0) {
            this.m_oDetailsArea.setRows(3);
        } else if (this.m_prereqchecker != null) {
            if (this.m_prereqchecker.getExecuteRemotePrereqs()) {
                this.m_oDetailsArea.setRows(4);
            } else {
                this.m_oDetailsArea.setRows(5);
            }
        } else {
            this.m_oDetailsArea.setRows(3);
        }
        this.m_oDetailsArea.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_oDetailsArea.setEditable(false);
        ScrollBox scroll = new ScrollBox((Component)((Object)this.m_oDetailsArea), 2, 1);
        this.m_oDetailsArea.setScrollBox(scroll);
        panel.add((Component)scroll, (Object)"North");
        return panel;
    }

    private LWContainer createProgressPanel() {
        this.m_progressbar = new ProgressBar();
        this.m_oRangemodel = new BoundedRangeModelImpl(0, this.m_vChecks.size(), 0);
        this.m_progressbar.setModel((StringRangeModel)this.m_oRangemodel);
        this.m_summaryText = new LWLabel();
        this.m_cardPanel = new LWContainer((LayoutManager)new CardLayout(INSET, INSET));
        this.m_cardPanel.add((Component)this.m_progressbar, (Object)"progressbar");
        this.m_cardPanel.add((Component)this.m_summaryText, (Object)"summary");
        return this.m_cardPanel;
    }

    public void setProgressUIListener(OipcpIProgressUIListener oProgressUIListener) {
        this.m_oProgressUIListener = oProgressUIListener;
    }

    public OipcpIProgressUIListener getProgressUIListener() {
        return this.m_oProgressUIListener;
    }

    public void updateStatus(final OipcpPrerequisiteCheck oCheck, final int status) {
        Runnable runnable = new Runnable(){

            public void run() {
                int numRows = OipfgPrereqProgressPanel.this.m_dataModel.getRowCount();
                for (int i = 0; i < numRows; ++i) {
                    OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)OipfgPrereqProgressPanel.this.m_dataModel.getData(0, i);
                    if (!oData.isMatch(oCheck)) continue;
                    if (oData.getStatus() != 5) {
                        oData.setStatus(status);
                    }
                    switch (status) {
                        case 1: {
                            OipfgPrereqProgressPanel.this.setSelectedRow(i);
                            oData.setSelectionEnabled(false);
                            OipfgPrereqProgressPanel.this.m_oDetailsArea.startOutput(i);
                            break;
                        }
                        case 2: {
                            OipfgPrereqProgressPanel.this.m_dataModel.setData(2, i, (Object)Boolean.TRUE);
                            OipfgPrereqProgressPanel.this.m_oDetailsArea.append(oData.getResultText());
                            OipfgPrereqProgressPanel.this.m_oDetailsArea.endOutput(i);
                            OipfgPrereqProgressPanel.this.incrementProgress();
                            oData.setStatus(status);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 6: {
                            OipfgPrereqProgressPanel.this.m_oDetailsArea.append(oData.getResultText());
                            OipfgPrereqProgressPanel.this.m_oDetailsArea.append(oData.getErrorText());
                            OipfgPrereqProgressPanel.this.m_oDetailsArea.endOutput(i);
                            oData.setSelectionEnabled(true);
                            if (OipfgPrereqProgressPanel.this.m_nFailedStartIndex == -1) {
                                OipfgPrereqProgressPanel.this.m_nFailedStartIndex = i;
                            }
                            OipfgPrereqProgressPanel.this.incrementProgress();
                        }
                    }
                    break;
                }
                OipfgPrereqProgressPanel.this.paintImmediate();
            }
        };
        this.executeOperation(runnable);
    }

    public void updateEndStatus(final OipcpPrereqResultsSummary oSummary) {
        if (this.m_oWizDialog != null) {
            this.m_oWizDialog.setNavButtonState(2, true);
            this.m_oWizDialog.setNavButtonState(4, true);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                OipfgPrereqProgressPanel.this.m_iFailures = oSummary.getFailedCount();
                OipfgPrereqProgressPanel.this.m_iWarnings = oSummary.getWarningsCount();
                int iAlreadyVerified = 0;
                Vector oChecks = oSummary.getChecksToRetry();
                int iChecks = oChecks.size();
                if (iChecks == 0 && continueOnAllChecksPass) {
                    OipfgPrereqProgressPanel.this.m_oWizDialog.onNext();
                }
                for (int i = 0; i < iChecks; ++i) {
                    OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)oChecks.get(i);
                    int numRows = OipfgPrereqProgressPanel.this.m_dataModel.getRowCount();
                    for (int j = 0; j < numRows; ++j) {
                        OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)OipfgPrereqProgressPanel.this.m_dataModel.getData(0, j);
                        if (!oData.isMatch(oCheck)) continue;
                        oData.setSelectionEnabled(true);
                        if (oData.getStatus() != 5) continue;
                        oData.setStatus(5);
                        if (oData.getPreviousStatus() != 3 && !oCheck.getResult().isSkipped()) continue;
                        ++iAlreadyVerified;
                    }
                }
                if (OipfgPrereqProgressPanel.this.m_nFailedStartIndex != -1) {
                    OipfgPrereqProgressPanel.this.setSelectedRow(OipfgPrereqProgressPanel.this.m_nFailedStartIndex);
                } else {
                    OipfgPrereqProgressPanel.this.setEmptySelection();
                }
                OipfgPrereqProgressPanel.this.m_iRequireVerification = oSummary.getUserVerifyCount() + OipfgPrereqProgressPanel.this.m_iFailures - iAlreadyVerified;
                OipfgPrereqProgressPanel.this.m_summaryText.setText(OipfgPrereqProgressPanel.this.getSummaryText());
                CardLayout cardLayout = (CardLayout)OipfgPrereqProgressPanel.this.m_cardPanel.getLayout();
                cardLayout.show((Container)OipfgPrereqProgressPanel.this.m_cardPanel, "summary");
                OipfgPrereqProgressPanel.this.m_oRetryButton.setEnabled(true);
                OipfgPrereqProgressPanel.this.m_oStopButton.setEnabled(false);
                OipfgPrereqProgressPanel.this.paintImmediate();
            }
        };
        this.executeOperation(runnable);
    }

    private String getSummaryText() {
        if (this.m_iFailures > 0) {
            if (this.m_iWarnings > 0) {
                Object[] sArgs = new String[]{new Integer(this.m_iFailures).toString(), new Integer(this.m_iWarnings).toString(), new Integer(this.m_iRequireVerification).toString()};
                return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0130", (Object[])sArgs);
            }
            Object[] sArgs = new String[]{new Integer(this.m_iFailures).toString(), new Integer(this.m_iRequireVerification).toString()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0126", (Object[])sArgs);
        }
        if (this.m_iWarnings > 0) {
            Object[] sArgs = new String[]{new Integer(this.m_iWarnings).toString(), new Integer(this.m_iRequireVerification).toString()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0131", (Object[])sArgs);
        }
        Object[] sArgs = new String[]{new Integer(this.m_iRequireVerification).toString()};
        return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0127", (Object[])sArgs);
    }

    public void enableButton(final LWButton btn, final boolean bEnable) {
        Runnable runnable = new Runnable(){

            public void run() {
                btn.setEnabled(bEnable);
            }
        };
        this.executeOperation(runnable);
    }

    private void executeOperation(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    public void updateStatusOnRetry(Vector v) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (OipfgPrereqProgressPanel.this.m_nFailedStartIndex != -1) {
                    OipfgPrereqProgressPanel.this.setSelectedRow(OipfgPrereqProgressPanel.this.m_nFailedStartIndex);
                } else {
                    OipfgPrereqProgressPanel.this.setEmptySelection();
                }
                OipfgPrereqProgressPanel.this.m_oRangemodel.setValue(0);
                OipfgPrereqProgressPanel.this.m_nFailedStartIndex = -1;
                OipfgPrereqProgressPanel.this.m_oRetryButton.setEnabled(false);
                OipfgPrereqProgressPanel.this.m_oStopButton.setEnabled(true);
                CardLayout cardLayout = (CardLayout)OipfgPrereqProgressPanel.this.m_cardPanel.getLayout();
                cardLayout.show((Container)OipfgPrereqProgressPanel.this.m_cardPanel, "progressbar");
                OipfgPrereqProgressPanel.this.paintImmediate();
            }
        };
        this.executeOperation(runnable);
    }

    public void updateStatusOnAbort(Vector v) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (OipfgPrereqProgressPanel.this.m_nFailedStartIndex != -1) {
                    OipfgPrereqProgressPanel.this.setSelectedRow(OipfgPrereqProgressPanel.this.m_nFailedStartIndex);
                } else {
                    OipfgPrereqProgressPanel.this.setEmptySelection();
                }
                OipfgPrereqProgressPanel.this.m_oStopButton.setEnabled(false);
                CardLayout cardLayout = (CardLayout)OipfgPrereqProgressPanel.this.m_cardPanel.getLayout();
                cardLayout.show((Container)OipfgPrereqProgressPanel.this.m_cardPanel, "summary");
                OipfgPrereqProgressPanel.this.paintImmediate();
            }
        };
        this.executeOperation(runnable);
    }

    private void setSelectedRow(int nRowIndex, boolean bSelected) {
        Grid oGrid = this.m_table.getGrid();
        oGrid.getGridSelection().setRowSelected(nRowIndex, bSelected);
        if (bSelected) {
            oGrid.scrollRowIntoView(nRowIndex);
        }
    }

    private void setSelectedRow(int nRowIndex) {
        this.setSelectedRow(nRowIndex, true);
    }

    private int getSelectedRowIndex() {
        Grid oGrid = this.m_table.getGrid();
        int[] rows = oGrid.getGridSelection().getSelectedRows();
        return rows != null && rows.length > 0 ? rows[0] : -1;
    }

    private void setEmptySelection() {
    }

    private void incrementProgress() {
        this.m_oRangemodel.setValue(this.m_oRangemodel.getValue() + 1);
    }

    private OipfgPrereqDisplayData getCheckData(int nRowIndex) {
        OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)this.m_dataModel.getData(0, nRowIndex);
        return oData;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(RETRY_COMMAND)) {
            this.m_oProgressUIListener.onPrereqRetry();
            this.enableButton(this.m_oRetryButton, false);
        } else if (e.getActionCommand().equalsIgnoreCase(STOP_COMMAND)) {
            this.m_oProgressUIListener.onPrereqStop();
            this.enableButton(this.m_oStopButton, false);
        }
    }

    public void rowSelecting(GridEvent oGridEvent) {
    }

    public void rowSelected(GridEvent oGridEvent) {
        int selectedIndex = this.getSelectedRowIndex();
        if (selectedIndex != -1) {
            this.m_oDetailsArea.scrollToIndex(selectedIndex);
        }
    }

    public void rowDeselecting(GridEvent oGridEvent) {
    }

    public void rowDeselected(GridEvent oGridEvent) {
    }

    public OiifwWizDialog getWizDialogObj() {
        return this.m_oWizDialog;
    }

    public int getGUImode() {
        return this.m_guimode;
    }

    public void setGUImode(int mode) {
        this.m_guimode = mode;
    }

    public void setWizDialogObj(OiifwWizDialog wizDialogObj) {
        if (wizDialogObj != null) {
            this.m_oWizDialog = wizDialogObj;
        }
    }

    public void keyPressed(KeyEvent e) {
        if (Character.toUpperCase(e.getKeyChar()) == 'R') {
            this.m_oProgressUIListener.onPrereqRetry();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    class OipfgCheckSelectionHandler
    implements GridEditListener {
        OipfgCheckSelectionHandler() {
        }

        public void cellEdited(GridEvent oEvent) {
            final GridEvent oGridEvent = oEvent;
            Runnable runnable = new Runnable(){

                public void run() {
                    int idx;
                    String sResID;
                    int currentRow = oGridEvent.getRow();
                    int currentCol = oGridEvent.getColumn();
                    int statusCol = 3;
                    OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)OipfgPrereqProgressPanel.this.m_dataModel.getData(statusCol, currentRow);
                    OipfgPrereqGrid oGrid = (OipfgPrereqGrid)OipfgPrereqProgressPanel.this.m_table.getGrid();
                    boolean bChecked = oGrid.getSelectionState(currentRow);
                    if (oData.isUserVerified()) {
                        oData.restorePreviousStatus();
                    } else {
                        oData.savePreviousStatus();
                        oData.setStatus(5);
                    }
                    if (bChecked) {
                        if (oData.getPreviousStatus() != 6) {
                            OipfgPrereqProgressPanel.this.m_iRequireVerification--;
                        }
                        sResID = "OIPFG0128";
                    } else {
                        if (oData.getStatus() != 6) {
                            OipfgPrereqProgressPanel.this.m_iRequireVerification++;
                        }
                        sResID = "OIPFG0129";
                    }
                    Object[] args = new String[]{oData.getTitle()};
                    OiiolTextLogger.appendText((String)OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)sResID, (Object[])args));
                    OipfgPrereqProgressPanel.this.m_summaryText.setText(OipfgPrereqProgressPanel.this.getSummaryText());
                    if (bChecked && (idx = OipfgCheckSelectionHandler.this.getNextCheckToVerify(currentRow)) != -1) {
                        OipfgPrereqProgressPanel.this.m_table.getGrid().scrollRowIntoView(idx);
                    }
                    OipfgPrereqProgressPanel.this.paintImmediate();
                }
            };
            OipfgPrereqProgressPanel.this.executeOperation(runnable);
        }

        private int getNextCheckToVerify(int iCurrIdx) {
            int nCount = OipfgPrereqProgressPanel.this.m_dataModel.getRowCount();
            int iNextIdx = this.getNextCheckToVerify(iCurrIdx + 1, nCount);
            if (iNextIdx == -1) {
                iNextIdx = this.getNextCheckToVerify(0, iCurrIdx);
            }
            return iNextIdx;
        }

        private int getNextCheckToVerify(int iStartIdx, int iEndIdx) {
            int iNextIdx = -1;
            for (int i = iStartIdx; i < iEndIdx; ++i) {
                OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)OipfgPrereqProgressPanel.this.m_dataModel.getData(3, i);
                if (!oData.requiresUserVerification()) continue;
                iNextIdx = i;
                break;
            }
            return iNextIdx;
        }

        public void cellEditing(GridEvent oGridEvent) {
        }
    }

    private class DetailsArea
    extends LWTextArea {
        private ScrollBox m_scrollPane;
        private Point[] m_scrollPoints;
        private Object m_lock;
        private static final String LINE = "========================================================";

        DetailsArea(String sText) {
            super(sText);
            this.m_lock = new Object();
            this.m_scrollPoints = new Point[OipfgPrereqProgressPanel.this.m_dataModel.getRowCount()];
        }

        public DetailsArea(String sText, int rows, int columns) {
            super(sText, rows, columns);
            this.m_lock = new Object();
            this.m_scrollPoints = new Point[OipfgPrereqProgressPanel.this.m_dataModel.getRowCount()];
        }

        public Object getLock() {
            return this.m_lock;
        }

        void setScrollBox(ScrollBox scrollBox) {
            this.m_scrollPane = scrollBox;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startOutput(int nIndex) {
            OipfgPrereqDisplayData oData = OipfgPrereqProgressPanel.this.getCheckData(nIndex);
            String sMsg = oData.getTitle() + System.getProperty("line.separator", "\n");
            Object object = this.getLock();
            synchronized (object) {
                this.append(sMsg);
            }
            this.updateScrollPointForCheck(nIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endOutput(int nIndex) {
            OipfgPrereqDisplayData oData = OipfgPrereqProgressPanel.this.getCheckData(nIndex);
            Object object = this.getLock();
            synchronized (object) {
                this.append("========================================================\n\n");
            }
        }

        private void updateScrollPointForCheck(int nIndex) {
            Point p;
            this.m_scrollPoints[nIndex] = p = this.m_scrollPane.getScrollPosition();
        }

        void scrollToIndex(int nIndex) {
            Point p = this.m_scrollPoints[nIndex];
            if (p != null) {
                this.m_scrollPane.setScrollPosition(p);
            }
        }
    }
}

